package gov.va.genisis2.exceptions;

public class GenisisDAOException extends Exception {
	private static final long serialVersionUID = -2914056153304310805L;
	
	/** The error message. */
	private final String message;
	
	/** The throwable. */
	private final Throwable throwable;

	/**
	 * @param message
	 *            The error message
	 */
	public GenisisDAOException(String message) {
		super(message);
		this.message = message;
		this.throwable = null;
	}
	
	/**
	 * @param message
	 *            The error message
	 * @param throwable
	 *            The throwable
	 */
	public GenisisDAOException(String message, Throwable throwable) {
		super(message, throwable);
		this.message = message;
		this.throwable = throwable;
	}

	/**
	 * @return the message
	 */
	@Override
	public String getMessage() {
		return message;
	}

	/**
	 * @return the throwable
	 */
	public Throwable getThrowable() {
		return throwable;
	}
}
